module           System.Commandz.Die
                 ( die
                 , dieWithCode
                 ) where

import           System.IO
                 ( hClose, stdin, stdout, stderr )

import           System.Exit
                 ( ExitCode (ExitSuccess, ExitFailure) )

import           System.Posix.Process
                 ( exitImmediately )

import           Text.Speak.IO
                 ( err )

import           Text.Strung
                 ( IsStrung )

die :: IsStrung a => a -> IO b
die = dieWithCode $ ExitFailure 1

dieWithCode :: IsStrung a => ExitCode -> a -> IO b
dieWithCode code e = failAfter f where
    f = err e >> closeStdio >> exitImmediately code

closeStdio = mapM_ hClose [stdin, stdout, stderr]

-- | If used after exitImmediately, the 'fail' will never be reached -- it's
-- just there to provide a wildcard return type.

failAfter f = f >> fail "fail"
