module           System.Commandz.Util
                 ( (.:), (.:.), (.::), (.::.)
                 , (<*.), (*>.)
                 , (>>.)
                 , fst3
                 , snd3
                 , fst4
                 , snd4
                 , thd4
                 , fth4
                 , shellQuote
                 , rejectEmpty
                 , hGetContentsStrict
                 , makeExceptT
                 , getOptsCmd
                 , maybeMVoid
                 )  where

import           Prelude hiding
                 ( putStr )

import           System.IO
                 ( hGetContents )

import           Control.Monad.Trans.Except
                 ( ExceptT (ExceptT)
                 , runExceptT
                 )

import           System.Exit
                 ( ExitCode (ExitSuccess, ExitFailure) )

import           System.Posix.Process
                 ( exitImmediately )

import           Data.Semigroup
                 ( Semigroup )

import qualified Data.List as DL
                 ( find )

import           Data.Semigroup
                 ( (<>) )

import           Control.Monad
                 ( when
                 , void )

import qualified Data.Text.IO as TIO
                 ( putStrLn )

import           Data.Set
                 ( fromList, member )

import           Text.Printf
                 ( printf )

import           Data.Maybe
                 ( isJust )

import           System.Console.Chalk
                 ( green, blue, cyan, bold, red )

import           Text.Strung as S
                 ( IsStrung
                 , find
                 , foldr
                 , fromString
                 , intercalate
                 , putStr )

import           System.Commandz.Types as T
                 ( CmdRun (Shell, Proc)
                 , optsCmdRun )

shellMagicChars = "({[<>]})" <> "\t\n " <> "'`\"" <>
                  "$!&?*" <> "|#%^~;\\"

shellQuote :: IsStrung a => a -> a
shellQuote txt = shellQuote' (contains' txt) where
    set = fromList shellMagicChars
    contains' = isJust . S.find find'
    find' = flip member set
    b = fromString ""
    sqEscape = fromString "'\\\''"
    sq = fromString "'"
    subQuote' = S.foldr subQuote'' b
    subQuote'' '\'' = (sqEscape <>)
    subQuote'' c = (fromString [c] <>)
    shellQuote' True = sq <> subQuote' txt <> sq
    shellQuote' False = txt

rejectEmpty = filter (/= "")

hGetContentsStrict h  = f =<< hGetContents h where
    f s = length s `seq` pure s

makeExceptT :: IO (Either l r) -> ExceptT l IO r
makeExceptT = ExceptT

getOptsCmd = get' . optsCmdRun where
    get' (Shell s) = shellQuote s
    get' (Proc s as) = quote' (s:as)
    quote' = intercalate " " . map shellQuote

-- Takes a function and a Maybe. If it's Nothing, results in pure (). If
-- it's Just, unwrap it, run the function, and return pure ().
maybeMVoid :: Applicative f => (a -> f b) -> Maybe a -> f ()
maybeMVoid g = maybe (pure ()) (void . g)

fst4 (a, _, _, _) = a
snd4 (_, b, _, _) = b
thd4 (_, _, c, _) = c
fth4 (_, _, _, d) = d

fst3 (x, _, _) = x
snd3 (_, x, _) = x

infixr 9 .:
infixr 9 .:.
infixr 9 .::
infixr 9 .::.
infixr 9 .:::

(z' .: z)   a = z' .    z a
(z' .:. z)  a = z' .:   z a
(z' .:: z)  a = z' .:.  z a
(z' .::. z) a = z' .::  z a
(z' .::: z) a = z' .::. z a

(f >>. g) x = f x >> g x

(f1 <*. f2) x = f1 x <* f2 x
(f1 *>. f2) x = f1 x *> f2 x
