{-# LANGUAGE FlexibleContexts #-}

module           Text.Speak
                 ( bullet
                 , cmdPref
                 , cmdPref'
                 , errStr
                 , infoStr
                 , warnStr
                 )  where

import qualified Prelude as P
                 ( putStr )

import           Prelude hiding
                 ( putStr )

import           Data.Semigroup
                 ( Semigroup )

import qualified Data.List as DL
                 ( find )

import           Data.Semigroup
                 ( (<>) )

import           System.Console.Chalk
                 ( underline
                 , bold
                 , red
                 , green
                 , yellow
                 , blue
                 , magenta
                 , cyan )

import           Text.Speak.Internal
                 ( bullet
                 , pref
                 , sp
                 )

import           Text.Speak.IO
                 ( cmdPref'
                 , wrap )

import           Text.Strung as S
                 ( find
                 , foldr
                 , fromString
                 , intercalate
                 , putStr
                 , toString )

import           Text.Strung
                 ( IsStrung )

cmdPref :: IsStrung a => a
cmdPref  = pref green

warnPref :: IsStrung a => a
warnPref = pref (bold . red)

errPref :: IsStrung a => a
errPref  = pref red

infoPref :: IsStrung a => a
infoPref  = pref blue

errStr :: IsStrung a => a -> a
errStr s = errPref <> fromString "Error: " <> s

warnStr :: IsStrung a => a -> a
warnStr s = warnPref <> fromString "Warning: " <> s

infoStr :: IsStrung a => a -> a
infoStr s = infoPref <> s
