module           Text.Speak.Internal
                 ( (.:)
                 , (.:.)
                 , (.::)
                 , (<=<:)
                 , join3
                 , appendNL
                 , bullet
                 , pref
                 , sp ) where

import           Control.Monad
                 ( (<=<) )

import           Text.Strung
                 ( IsStrung
                 , fromString )

bullet :: IsStrung a => a
bullet = fromString "٭"

pref :: IsStrung a => (a -> a) -> a
pref col = col bullet <> sp

sp :: IsStrung a => a
sp = fromString " "

appendNL :: IsStrung a => a -> a
appendNL = (<> fromString "\n")

(f .: g)   x = f .    g x
(f .:. g)  x = f .:   g x
(f .:: g)  x = f .:.  g x
(a <=<: b)   x = a <=<    b x

join3 a b c = a <> b <> c
